import time

import pandas as pd
from pandas import DataFrame

from stock_sql.query_platform import pro
from stock_sql.sql_env import *
from datetime import datetime, timedelta
from stock_sql.orm.key_word import KeyWord

logging.basicConfig(
    filename='src/tushare_news.log',  # 日志文件名
    level=logging.DEBUG,  # 日志级别
    format='%(asctime)s - %(levelname)s - %(message)s',  # 日志格式
    force=True
)


def update_by_date(new_date: datetime):
    add_list = []
    content_set = []
    key_word_list = []
    up = new_date.strftime('%Y-%m-%d 00:00:00')
    mid = new_date.strftime('%Y-%m-%d 18:00:00')
    down = new_date.strftime('%Y-%m-%d 23:59:59')
    df_up: DataFrame = pro.news(src='wallstreetcn', start_date=up, end_date=mid)
    df_mid: DataFrame = pro.news(src='wallstreetcn', start_date=mid, end_date=down)
    df_top = pd.concat([df_up, df_mid], axis=0)
    for index, row in df_top.iterrows():
        a_time = row["datetime"]
        content = row["content"]
        title = row["title"]
        if content in content_set:
            continue
        else:
            content_set.append(content)
            add_list.append([a_time, content, title])
            key_word = KeyWord()
            key_word.src = 'tushare'
            key_word.type = '华尔街'
            key_word.title = title
            key_word.content = content
            key_word.update_time = a_time
            key_word.cache_time = a_time
            key_word_list.append(key_word)

    for item in key_word_list:
        count = stock_session.query(KeyWord).filter(KeyWord.src == item.src).filter(
            KeyWord.type == item.type).filter(
            KeyWord.cache_time == item.cache_time).count()
        if count != 0:
            continue
        stock_session.add(item)
    stock_session.commit()


def wallstreetcn():
    # update yesterday news
    today = datetime.now()
    yesterday = today - timedelta(days=1)
    update_by_date(yesterday)
    # update dateflag news
    flag_name = 'src/news_flag.txt'
    with open(flag_name, 'r', encoding='utf-8') as file:
        date_falag = file.readlines()  # 读取所有行
    start_date = datetime.strptime(date_falag[0][0:10], "%Y-%m-%d")
    for i in range(1,11):
        time.sleep(225)
        new_date = start_date - timedelta(days=i)
        update_by_date(new_date)
        with open(flag_name, 'w', encoding='utf-8') as file:
            file.writelines(new_date.strftime("%Y-%m-%d"))



if __name__ == '__main__':
    try:
        wallstreetcn()
    except Exception as e:
        print(f"exec error: {e}")
        logging.error(f"exec error: {e}")
