import akshare as ak


def get_ah_stocks():
    # 获取A股股票列表
    a_stock_list = ak.stock_zh_a_spot_em()
    a_stock_list = a_stock_list[["代码", "名称"]]

    # 获取港股股票列表
    h_stock_list = ak.stock_hk_spot_em()
    h_stock_list = h_stock_list[["代码", "名称"]]

    # 获取A股和港股的公司名称及代码
    a_names = a_stock_list["名称"].str.strip().tolist()
    a_codes = a_stock_list["代码"].tolist()
    h_names = h_stock_list["名称"].str.strip().tolist()
    h_codes = h_stock_list["代码"].tolist()

    # 初始化结果列表
    ah_stocks = []

    # 遍历A股公司，寻找对应的港股公司
    for a_name, a_code in zip(a_names, a_codes):
        for h_name, h_code in zip(h_names, h_codes):
            # 判断名称是否有包含关系
            if a_name in h_name or h_name in a_name:
                ah_stocks.append({"A_code": a_code, "H_code": h_code, "A_name": a_name, "H_name": h_name})
                break  # 找到一个匹配后跳出循环

    return ah_stocks


# 主程序
if __name__ == "__main__":
    ah_stocks = get_ah_stocks()
    print("AH股股票列表：")
    for stock in ah_stocks:
        print(
            f"A股代码：{stock['A_code']}, 港股代码：{stock['H_code']}, A公司名称：{stock['A_name']},H公司名称：{stock['H_name']}")