import pandas as pd

from stock_sql.sql_env import stock_db
from tool.stock_utils import pd_chunk


def query_stock_info():
    df_chunk = pd.read_sql('SELECT * FROM stock.stock_basic', stock_db, chunksize=2000)

    return pd_chunk(df_chunk)


def query_gold():
    df_chunk = pd.read_sql('SELECT * FROM stock.stock_gold order by datetime desc limit 300', stock_db, chunksize=2000)
    return pd_chunk(df_chunk)


def query_keyword(type="", number=100):
    query_sql = f"SELECT * FROM stock.key_word where 1=1 and type != '实时上升'  order by update_time desc limit {number}"
    if type != "":
        query_sql = f"SELECT * FROM stock.key_word where 1=1 and type != '实时上升' and src = '{type}'  order by update_time desc limit {number}"
    df_chunk = pd.read_sql(query_sql, stock_db, chunksize=2000)
    return pd_chunk(df_chunk)


def query_etf(etf_name=''):
    query_sql = "select * from stock.stock_etf where 1=1"
    if etf_name is not None and etf_name != "":
        query_sql = query_sql + f" and etf_name = '{etf_name}'"
    query_sql = query_sql + " order by etf_date desc"
    df_chunk = pd.read_sql(query_sql, stock_db, chunksize=2000)
    return pd_chunk(df_chunk)


def query_ditinct_code(distinct_code: ""):
    query_sql = ""
    if distinct_code == "etf_name":
        query_sql = "select distinct(etf_name) from stock.stock_etf"
    if distinct_code == "src":
        query_sql = "select distinct(src) from stock.key_word"
    df_chunk = pd.read_sql(query_sql, stock_db, chunksize=2000)
    return pd_chunk(df_chunk)

    return None


def query_stock_detail(code: str):
    if code == "" or code is None:
        return None
    df_chunk = pd.read_sql(f'SELECT * FROM stock.stock_detail where code ="{code}" order by calendar_date', stock_db,
                           chunksize=2000)
    return pd_chunk(df_chunk)


def query_keyword_like(keyword: str, number=100):
    # query_sql = f"SELECT * FROM stock.key_word where title like '%{keyword}%' or content like '%{keyword}%' order by update_time desc limit {number}"
    # # if type != "":
    # #     query_sql = f"SELECT * FROM stock.key_word where 1=1 and type != '实时上升' and src = '{type}'  order by update_time desc limit {number}"
    # df_chunk = pd.read_sql(query_sql, stock_db, chunksize=2000)
    # return pd_chunk(df_chunk)
    query_sql = """
            SELECT * FROM stock.key_word 
            WHERE title LIKE %s OR content LIKE %s 
            ORDER BY update_time DESC 
            LIMIT %s
        """
    params = (f'%{keyword}%', f'%{keyword}%', number)

    df_chunk = pd.read_sql(query_sql, stock_db, params=params, chunksize=2000)
    return pd.concat(df_chunk)  # Assuming you want to concatenate chunks into a single DataFrame


if __name__ == '__main__':
    print("get_ah()")
    # print(pro)
