import time
import baostock as bs
import requests
import urllib
import pandas as pd
from bs4 import BeautifulSoup
from pandas import DataFrame
import tushare as ts

from tool.stock_utils import denifi_YYYYMMDD

pro = ts.pro_api('09f391cea7cefe5233e34b755ecf064e62a6c753c355513acd7ee4ac')
ts.set_token('09f391cea7cefe5233e34b755ecf064e62a6c753c355513acd7ee4ac')


def query_stocks_status_topd(date_query: str):
    #### 获取某日所有证券信息 ####
    rs = bs.query_all_stock(day=date_query)
    print('query_all_stock respond error_code:' + rs.error_code)
    print('query_all_stock respond  error_msg:' + rs.error_msg)

    #### 打印结果集 ####
    data_list = []
    while (rs.error_code == '0') & rs.next():
        # 获取一条记录，将记录合并在一起
        data_list.append(rs.get_row_data())
    result = pd.DataFrame(data_list, columns=rs.fields)
    return result


def query_stock_basic_topd(code: str):
    time.sleep(0.1)
    # 获取证券基本资料
    rs = bs.query_stock_basic(code=code)
    print('query_stock_basic respond error_code:' + rs.error_code)
    print('query_stock_basic respond  error_msg:' + rs.error_msg)
    # 打印结果集
    data_list = []
    while (rs.error_code == '0') & rs.next():
        # 获取一条记录，将记录合并在一起
        data_list.append(rs.get_row_data())
    result = pd.DataFrame(data_list, columns=rs.fields)
    return result


def query_adjust_factor_topd(code: str):
    time.sleep(0.3)
    # 获取证券基本资料
    rs = bs.query_adjust_factor(code=code, start_date="2010-01-01")
    print('query_stock_basic respond error_code:' + rs.error_code)
    print('query_stock_basic respond  error_msg:' + rs.error_msg)
    # 打印结果集
    data_list = []
    while (rs.error_code == '0') & rs.next():
        # 获取一条记录，将记录合并在一起
        data_list.append(rs.get_row_data())
    result = pd.DataFrame(data_list, columns=rs.fields)
    return result


def query_history_k_data_plus_topd(code, start_time: str, end_time: str, adjustflag: str):
    rs = bs.query_history_k_data_plus(code,
                                      "date,code,open,high,low,close,preclose,volume,amount,adjustflag,turn,tradestatus,pctChg,peTTM,pbMRQ,psTTM,pcfNcfTTM,isST",
                                      start_date=start_time, end_date=end_time,
                                      frequency="d", adjustflag=adjustflag)
    data_list = []
    while (rs.error_code == '0') & rs.next():
        # 获取一条记录，将记录合并在一起
        data_list.append(rs.get_row_data())
    result = pd.DataFrame(data_list, columns=rs.fields)
    result.replace("", None, inplace=True)
    return result
    # any columns get "" # result[(result == "").any(axis=1)


def query_stock_industry_topd():
    # 获取行业分类数据
    rs = bs.query_stock_industry()
    # rs = bs.query_stock_basic(code_name="浦发银行")
    print('query_stock_industry error_code:' + rs.error_code)
    print('query_stock_industry respond  error_msg:' + rs.error_msg)
    # 打印结果集
    industry_list = []
    while (rs.error_code == '0') & rs.next():
        # 获取一条记录，将记录合并在一起
        industry_list.append(rs.get_row_data())
    result = pd.DataFrame(industry_list, columns=rs.fields)
    return result


def query_top_stock(top_num: int):
    rs = None
    if top_num == 50:
        rs = bs.query_sz50_stocks()
    if top_num == 300:
        rs = bs.query_hs300_stocks()
    if top_num == 500:
        rs = bs.query_zz500_stocks()
    if rs == None:
        return rs
    print('query_top error_code:' + rs.error_code)
    print('query_top  error_msg:' + rs.error_msg)
    # 打印结果集
    sztop_stocks = []
    while (rs.error_code == '0') & rs.next():
        # 获取一条记录，将记录合并在一起
        sztop_stocks.append(rs.get_row_data())
    result = pd.DataFrame(sztop_stocks, columns=rs.fields)
    return result


def query_godel(query_number: int):
    response = requests.get(
        f'https://platform.smm.cn/quotecenter/instrument/au0000/kline?time_type=1day&page=1&limit={query_number}')

    # 检查请求是否成功
    if response.status_code == 200:
        data = response.json()  # 如果返回的是 JSON 格式
        df = pd.DataFrame(data["data"])
        return df
    return None


def query_trade_cal(denify_day=denifi_YYYYMMDD(1)) -> DataFrame:
    df = pro.trade_cal(start_date=denify_day, is_open='1')
    df = df[df["cal_date"] <= denifi_YYYYMMDD()]
    return df


def pro_bar(code: str, asset="E", start_date=denifi_YYYYMMDD(1)):
    df = ts.pro_bar(ts_code=code, start_date=start_date, asset=asset, freq="D", adj="qfq")
    return df


def stock_company(code: str):
    df = pro.stock_company(ts_code=code)
    return df


def stk_managers(code: str):
    df = pro.stk_managers(ts_code=code)
    return df


def stk_rewards(code: str):
    df = pro.stk_rewards(ts_code=code)
    return df


def query_global_index(index: str):
    # current_time = datetime.now()
    # one_year_ago = current_time - relativedelta(years=1)
    # one_year_ago_str = one_year_ago.strftime('%Y%m%d')
    df = pro.index_global(ts_code=index, start_date=denifi_YYYYMMDD(1))
    return df


def get_ah():
    # http://www.aastocks.com/tc/stocks/market/ah.aspx?sort=5&order=0&filter=3
    url_page = f"http://www.aastocks.com/tc/stocks/market/ah.aspx?sort=5&order=0&filter=3"
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'}
    page = urllib.request.urlopen(url_page)
    soup = BeautifulSoup(page, 'html.parser')
    tables = soup.find(attrs={'class': 'tblAHADR'})
    rows = tables.find_all('tr')
    ret_list = []
    for row in rows[2:-1]:
        # 获取行中的所有单元格
        cells = row.find_all(['td', 'th'])  # 包含数据单元格和表头单元格
        cell_data = [cell.get_text(strip=True) for cell in cells]
        h = cell_data[1][0:8]
        a = cell_data[4][0:9]
        # pd = pro.hk_daily(ts_code=h)
        ret_list.append([cell_data[0], h, a, cell_data[-1]])
    df = pd.DataFrame(ret_list, columns=['名称', 'H股', 'A股', '溢价'])
    return df
