from sqlalchemy import Column, Integer, String, Float, Date
from sqlalchemy.orm import declarative_base

Base = declarative_base()


class TradeTime(Base):
    __tablename__ = 'trade_time'
    calendar_date = Column(Date, primary_key=True, nullable=False)
    is_trading_day = Column(Integer)

    def __repr__(self):
        return f"<TradeTime(calendar_date={self.calendar_date}, is_trading_day={self.is_trading_day})>"
