# coding: utf-8
from sqlalchemy import Column, Date, Float, String, Text
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()
metadata = Base.metadata


class StockIncome(Base):
    __tablename__ = 'stock_income'

    ts_code = Column(String(50, 'utf8mb4_unicode_ci'), primary_key=True, nullable=False)
    ann_date = Column(Date, primary_key=True, nullable=False)
    f_ann_date = Column(Date, primary_key=True, nullable=False)
    end_date = Column(Date, primary_key=True, nullable=False)
    report_type = Column(Text(collation='utf8mb4_unicode_ci'))
    comp_type = Column(Text(collation='utf8mb4_unicode_ci'))
    end_type = Column(Text(collation='utf8mb4_unicode_ci'))
    basic_eps = Column(Float(asdecimal=True))
    diluted_eps = Column(Float(asdecimal=True))
    total_revenue = Column(Float(asdecimal=True))
    revenue = Column(Float(asdecimal=True))
    int_income = Column(Text(collation='utf8mb4_unicode_ci'))
    prem_earned = Column(Text(collation='utf8mb4_unicode_ci'))
    comm_income = Column(Text(collation='utf8mb4_unicode_ci'))
    n_commis_income = Column(Text(collation='utf8mb4_unicode_ci'))
    n_oth_income = Column(Text(collation='utf8mb4_unicode_ci'))
    n_oth_b_income = Column(Text(collation='utf8mb4_unicode_ci'))
    prem_income = Column(Text(collation='utf8mb4_unicode_ci'))
    out_prem = Column(Text(collation='utf8mb4_unicode_ci'))
    une_prem_reser = Column(Text(collation='utf8mb4_unicode_ci'))
    reins_income = Column(Text(collation='utf8mb4_unicode_ci'))
    n_sec_tb_income = Column(Text(collation='utf8mb4_unicode_ci'))
    n_sec_uw_income = Column(Text(collation='utf8mb4_unicode_ci'))
    n_asset_mg_income = Column(Text(collation='utf8mb4_unicode_ci'))
    oth_b_income = Column(Text(collation='utf8mb4_unicode_ci'))
    fv_value_chg_gain = Column(Float(asdecimal=True))
    invest_income = Column(Float(asdecimal=True))
    ass_invest_income = Column(Float(asdecimal=True))
    forex_gain = Column(Text(collation='utf8mb4_unicode_ci'))
    total_cogs = Column(Float(asdecimal=True))
    oper_cost = Column(Float(asdecimal=True))
    int_exp = Column(Text(collation='utf8mb4_unicode_ci'))
    comm_exp = Column(Text(collation='utf8mb4_unicode_ci'))
    biz_tax_surchg = Column(Float(asdecimal=True))
    sell_exp = Column(Float(asdecimal=True))
    admin_exp = Column(Float(asdecimal=True))
    fin_exp = Column(Float(asdecimal=True))
    assets_impair_loss = Column(Float(asdecimal=True))
    prem_refund = Column(Text(collation='utf8mb4_unicode_ci'))
    compens_payout = Column(Text(collation='utf8mb4_unicode_ci'))
    reser_insur_liab = Column(Text(collation='utf8mb4_unicode_ci'))
    div_payt = Column(Text(collation='utf8mb4_unicode_ci'))
    reins_exp = Column(Text(collation='utf8mb4_unicode_ci'))
    oper_exp = Column(Text(collation='utf8mb4_unicode_ci'))
    compens_payout_refu = Column(Text(collation='utf8mb4_unicode_ci'))
    insur_reser_refu = Column(Text(collation='utf8mb4_unicode_ci'))
    reins_cost_refund = Column(Text(collation='utf8mb4_unicode_ci'))
    other_bus_cost = Column(Text(collation='utf8mb4_unicode_ci'))
    operate_profit = Column(Float(asdecimal=True))
    non_oper_income = Column(Float(asdecimal=True))
    non_oper_exp = Column(Float(asdecimal=True))
    nca_disploss = Column(Float(asdecimal=True))
    total_profit = Column(Float(asdecimal=True))
    income_tax = Column(Float(asdecimal=True))
    n_income = Column(Float(asdecimal=True))
    n_income_attr_p = Column(Float(asdecimal=True))
    minority_gain = Column(Float(asdecimal=True))
    oth_compr_income = Column(Float(asdecimal=True))
    t_compr_income = Column(Float(asdecimal=True))
    compr_inc_attr_p = Column(Float(asdecimal=True))
    compr_inc_attr_m_s = Column(Float(asdecimal=True))
    ebit = Column(Float(asdecimal=True))
    ebitda = Column(Float(asdecimal=True))
    insurance_exp = Column(Text(collation='utf8mb4_unicode_ci'))
    undist_profit = Column(Text(collation='utf8mb4_unicode_ci'))
    distable_profit = Column(Text(collation='utf8mb4_unicode_ci'))
    rd_exp = Column(Float(asdecimal=True))
    fin_exp_int_exp = Column(Float(asdecimal=True))
    fin_exp_int_inc = Column(Float(asdecimal=True))
    transfer_surplus_rese = Column(Text(collation='utf8mb4_unicode_ci'))
    transfer_housing_imprest = Column(Text(collation='utf8mb4_unicode_ci'))
    transfer_oth = Column(Text(collation='utf8mb4_unicode_ci'))
    adj_lossgain = Column(Text(collation='utf8mb4_unicode_ci'))
    withdra_legal_surplus = Column(Text(collation='utf8mb4_unicode_ci'))
    withdra_legal_pubfund = Column(Text(collation='utf8mb4_unicode_ci'))
    withdra_biz_devfund = Column(Text(collation='utf8mb4_unicode_ci'))
    withdra_rese_fund = Column(Text(collation='utf8mb4_unicode_ci'))
    withdra_oth_ersu = Column(Text(collation='utf8mb4_unicode_ci'))
    workers_welfare = Column(Text(collation='utf8mb4_unicode_ci'))
    distr_profit_shrhder = Column(Text(collation='utf8mb4_unicode_ci'))
    prfshare_payable_dvd = Column(Text(collation='utf8mb4_unicode_ci'))
    comshare_payable_dvd = Column(Text(collation='utf8mb4_unicode_ci'))
    capit_comstock_div = Column(Text(collation='utf8mb4_unicode_ci'))
    continued_net_profit = Column(Float(asdecimal=True))
    update_flag = Column(Float(asdecimal=True), primary_key=True, nullable=False)
