from sqlalchemy import Column, BigInteger, String, Float, Date
from sqlalchemy.orm import declarative_base

Base = declarative_base()


class StockDetail(Base):
    __tablename__ = 'stock_detail'
    calendar_date = Column(Date, nullable=False, primary_key=True)
    code = Column(String(50), nullable=False, primary_key=True)
    adjustflag = Column(BigInteger, nullable=False, primary_key=True)

    open = Column(Float)
    high = Column(Float)
    low = Column(Float)
    close = Column(Float)
    preclose = Column(Float)
    volume = Column(BigInteger)
    amount = Column(BigInteger)
    turn = Column(Float)
    tradestatus = Column(BigInteger)
    pctChg = Column(Float)
    isST = Column(BigInteger)

    def __repr__(self):
        return f"null"
