import logging
import time
import traceback
import akshare as ak
import tushare as ts
from pandas import DataFrame
from sqlalchemy import text
from stock_sql.orm.stock_gold import StockGold
from stock_sql.orm.stock_income import StockIncome
from stock_sql.orm.stock_indicator import StockIndicator
from stock_sql.orm.stock_rate import StockRate
from stock_sql.query_platform import query_godel
from stock_sql.sql_env import *
from tool.stock_utils import today_YYYYMMDD, tushare2baostock, baostock2tushare

pro = ts.pro_api('09f391cea7cefe5233e34b755ecf064e62a6c753c355513acd7ee4ac')

# logging.basicConfig(filename='app.log', encoding='utf-8',
#                         format='%(asctime)s - %(filename)s[line:%(lineno)d] - %(levelname)s: %(message)s',
#                         level=logging.DEBUG)


logging.basicConfig(
    filename='src/app.log',   # 日志文件名
    level=logging.DEBUG,  # 日志级别
    format='%(asctime)s - %(levelname)s - %(message)s',  # 日志格式
    force=True
)


def rebuild_trade_time():
    stock_session.execute(text("Delete FROM stock.trade_cal"))
    stock_session.commit()
    df = pro.trade_cal(end_date=today_YYYYMMDD())
    with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
        res = df.to_sql('trade_cal', stock_db, index=False, if_exists='append', chunksize=5000)
        print(res)


def rebuild_stock_basic():
    stock_session.execute(text("Delete FROM stock.stock_basic"))
    stock_session.commit()
    df = pro.stock_basic(
        fields='ts_code,symbol,name,area,industry,cnspell,market,act_name,list_date,act_ent_type,is_hs')
    with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
        res = df.to_sql('stock_basic', stock_db, index=False, if_exists='append', chunksize=5000)
        print(res)


def rebuild_stock_detail():
    insert_sql = ("SELECT distinct(ts_code) FROM stock.stock_detail")
    stmt_inserted = text(insert_sql)
    results_insterted = stock_session.execute(stmt_inserted)
    inseted_set = [row_r[0] for row_r in results_insterted]

    df_code: DataFrame = pro.stock_basic(
        fields='ts_code,symbol,name,area,industry,cnspell,market,act_name,list_date,act_ent_type,is_hs')
    for index, row in df_code.iterrows():
        code = row["ts_code"]
        if code in inseted_set:
            continue
        stock_session.execute(text(f"Delete FROM stock.stock_detail where ts_code = '{code}'"))
        stock_session.commit()
        df = ts.pro_bar(ts_code=code, freq="D", adj="qfq")
        with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
            df.to_sql('stock_detail', stock_db, index=False, if_exists='append', chunksize=5000)
        time.sleep(0.5)


def rebuild_hs_const():
    stock_session.execute(text("Delete FROM stock.hs_const"))
    stock_session.commit()
    df = pro.hs_const(hs_type="SH")
    # stock_session.query(TradeTime).delete()
    with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
        res = df.to_sql('hs_const', stock_db, index=False, if_exists='append', chunksize=5000)
        print(res)

    df = pro.hs_const(hs_type="SZ")
    # stock_session.query(TradeTime).delete()
    with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
        res = df.to_sql('hs_const', stock_db, index=False, if_exists='append', chunksize=5000)
        print(res)


def rebuild_AH():
    stock_session.execute(text("Delete FROM stock.a_h"))
    stock_session.commit()
    df = ak.stock_zh_ah_name()
    with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
        res = df.to_sql('a_h', stock_db, index=False, if_exists='append', chunksize=5000)
        print(res)


def rebuild_sw_industry():
    src = 'SW2021'
    industry: DataFrame = pro.index_classify(src=src)
    stock_session.query(StockSwindustry).delete()
    data_list = []
    for index, row in industry.iterrows():
        sw_industry = StockSwindustry()
        sw_industry.index_code = row["index_code"]
        sw_industry.industry_code = row["industry_code"]
        sw_industry.industry_name = row["industry_name"]
        sw_industry.src = row["src"]
        sw_industry.parent_code = row["parent_code"]
        sw_industry.is_pub = row["is_pub"]
        sw_industry.level = row["level"]
        data_list.append(sw_industry)
    stock_session.add_all(data_list)
    stock_session.commit()

    insert_sql = ("SELECT * FROM stock.stock_swindustry where level = 'L1'")
    stmt_inserted = text(insert_sql)
    results_insterted = stock_session.execute(stmt_inserted)
    inseted_set = [row_r[0] for row_r in results_insterted]
    for l1_code in inseted_set:
        stock_industry: DataFrame = pro.index_member_all(l1_code=l1_code)
        for index, row in stock_industry.iterrows():
            stock_info: StockInfo = stock_session.query(StockInfo).filter(
                StockInfo.code == tushare2baostock(row["ts_code"])).first()
            print(stock_info)
            if stock_info is not None:
                stock_info.l1_code = row["l1_code"]
                stock_info.l1_name = row["l1_name"]
                stock_info.l2_code = row["l2_code"]
                stock_info.l2_name = row["l2_name"]
                stock_info.l3_code = row["l3_code"]
                stock_info.l3_name = row["l3_name"]
                stock_session.commit()
    pass


def rebuild_income():
    with f_Session() as t_session:
        try:
            stock_info_list = t_session.query(StockInfo).filter(StockInfo.type == 1).filter(StockInfo.status == 1).all()
            stock_code_list = [stock.code for stock in stock_info_list]
            if len(stock_code_list) == 0:
                return
            t_session.query(StockIncome).delete()
            t_session.commit()
            for stock in stock_code_list:
                time.sleep(0.3)
                code = baostock2tushare(stock)
                df = pro.income(ts_code=code)
                with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
                    res = df.to_sql('stock_income', stock_db, index=False, if_exists='append', chunksize=5000)
                time.sleep(0.3)
        except Exception as e:
            logging.error(f"{stock} income error:{e}")
            t_session.rollback()  # 回滚事务


def rebuild_rate():
    stock_session.query(StockRate).delete()
    stock_session.close()
    df = pro.shibor()
    df.to_sql('stock_rate', stock_db, index=False, if_exists='append', chunksize=5000)
    df = pro.shibor_lpr()
    df.to_sql('stock_rate', stock_db, index=False, if_exists='append', chunksize=5000)


def rebuild_indicator():
    stock_list = stock_session.query(StockInfo).filter(StockInfo.type == 1).filter(StockInfo.status == 1).all()
    stock_code_list = [stock.code for stock in stock_list]
    if len(stock_code_list) == 0:
        return
    stock_session.query(StockIndicator).delete()
    stock_session.commit()
    stock_session.close()
    df = None
    try:
        for stock in stock_code_list:
            ts_code = baostock2tushare(stock)
            df = pro.fina_indicator(ts_code=ts_code)
            with stock_db.connect() as connection:  # 确保 stock_db 是一个 SQLAlchemy 引擎
                res = df.to_sql('stock_indicator', stock_db, index=False, if_exists='append', chunksize=5000)
            time.sleep(0.3)
    except Exception as e:
        logging.error(f"{stock} indicator error:{e}")


def rebuild_gold():
    stock_session.execute(text("Delete FROM stock.stock_gold"))
    stock_session.commit()
    gole_df = query_godel(5000)
    if gole_df is not None:
        stock_session.query(StockGold).delete()
        stock_session.commit()
        stock_session.close()
    try:
        res = gole_df.to_sql('stock_gold', stock_db, index=False, if_exists='append', chunksize=5000)
        print(res)
    except Exception as e:
        logging.error(f"stock_gold error:{e}")


# update code last info
def update_stock_info():
    # logging.info("script : rebuild_gold")
    # rebuild_gold()
    # # logging.info("script : rebuild_trade_time")
    # rebuild_trade_time()
    # rebuild_hs_const()
    # rebuild_AH()
    # rebuild_stock_basic()
    rebuild_stock_detail()
    # logging.info("script : update_code_status")
    # update_code_status()
    # logging.info("script : insert_new_base_info")
    # insert_new_base_info()

    # logging.info("script : insert_new_stock_detail")
    # insert_new_stock_detail()
    # logging.info("script : rebuild_last_divid_stock")
    # rebuild_last_divid_stock()
    # logging.info("script : stock_last_time_update")
    # stock_last_time_update()
    # logging.info("script : stock_increment_update")
    # stock_increment_update()
    # logging.info("script : stock_last_time_update")
    # stock_last_time_update()

    # logging.info("script : rebuild_rate")
    # rebuild_rate()
    # logging.info("script : rebuild_top_industry")
    # rebuild_top_industry()
    # logging.info("script : rebuild_sw_industry")
    # rebuild_sw_industry()
    # logging.info("script : rebuild_income")
    # rebuild_income()
    # logging.info("script : rebuild_indicator")
    # rebuild_indicator()
    # logging.info("script : update_divid")
    # update_divid()
    pass


if __name__ == '__main__':
    try:

        update_stock_info()

    except Exception as e:
        # 处理其他所有异常
        error_message = traceback.format_exc()
        print(f"捕获到其他异常: {error_message}")
        logging.error(error_message)
    else:
        logging.info("数据脚本同步更新成功")
