import streamlit as st
from pandas import DataFrame

from stock_sql.query_platform import pro
from tool.stock_utils import denifi_YYYYMMDD, denifi_YYYYMM

st.markdown("### CPI 全国同比")
pd_cpi: DataFrame = pro.cn_cpi(start_m=denifi_YYYYMM(10))
st.line_chart(pd_cpi, x="month", y=["nt_yoy"])

st.markdown("### PPI 全国同比")
pd_ppi: DataFrame = pro.cn_ppi(start_m=denifi_YYYYMM(10))
st.line_chart(pd_ppi, x="month", y=["ppi_yoy", "ppi_mp_yoy", "ppi_cg_yoy"])

st.markdown("### 货币供应量")
pd_cn_m: DataFrame = pro.cn_m(start_m=denifi_YYYYMM(5))
st.line_chart(pd_cn_m, x="month", y=["m0", "m1", "m2"])

st.markdown("### 社融数据（月度）")
pd_month: DataFrame = pro.sf_month(start_m=denifi_YYYYMM(10))
st.line_chart(pd_month, x="month", y=["inc_month"])

st.markdown("### PMI 采购经理人")
pd_pmi: DataFrame = pro.cn_pmi(start_m=denifi_YYYYMM(10), fields='month,pmi010000,pmi010100,pmi010200,pmi010300')
print(pd_pmi)
st.line_chart(pd_pmi, x="month", y=["pmi010000", "pmi010100", "pmi010200", "pmi010300"])

st.markdown("### shibor 银行间拆借利率")
pd_shibor = pro.shibor(start_date=denifi_YYYYMMDD(5))
st.line_chart(pd_shibor, x="date", y="1y")

st.markdown("### LPR 贷款基础利率")
pd_lpr = pro.shibor_lpr(start_date=denifi_YYYYMMDD(5))
st.line_chart(pd_lpr, x="date", y="1y")

st.markdown("### Libor 伦敦拆借利率")
pd_libor = pro.libor(start_date=denifi_YYYYMMDD(5))
st.line_chart(pd_libor, x="date", y="12m")

st.markdown("### 国债收益率曲线利率")
pd_us_tycr = pro.us_tycr(start_date=denifi_YYYYMMDD(5))
st.line_chart(pd_us_tycr, x="date", y="y1")

# st.markdown("### 温州民间借贷利率")
# pd_wenzhou = pro.wz_index(start_date=denifi_YYYYMMDD(5))
# print(denifi_YYYYMMDD(5))
# st.line_chart(pd_wenzhou, x="date", y="m12_rate")
