import streamlit as st
from datetime import time, datetime, timedelta
import pandas as pd
import altair as alt
import plotly.graph_objects as plt

st.set_page_config(layout="wide")

# origin data
pd_data = pd.read_hdf("result_data.h5", "sh.000001")
pd_data['amount'] = pd.to_numeric(pd_data['amount'], errors='coerce')
pd_data['volume'] = pd.to_numeric(pd_data['volume'], errors='coerce')
pd_data["am/vol"] = pd_data['amount'] / pd_data["volume"]  # 额度/数量
start_time = pd_data["date"].min()
end_time = pd_data["date"].max()

# time slider
time_slider = st.slider(
    "Select a date range",
    value=(pd_data["date"].min().date(), pd_data["date"].max().date()),
    step=timedelta(days=1),
    format="MM/DD/YYYY"

)

st.write("Start time:", time_slider)

selected_data = pd_data[
    (pd_data["date"] >= pd.to_datetime(time_slider)[0]) & (pd_data["date"] <= pd.to_datetime(time_slider)[1])]

fig = plt.Figure()
# Add a line trace
fig.add_trace(plt.Scatter(x=selected_data['date'], y=selected_data['close']))
# fig.update_layout(xaxis=dict(tickmode='auto', nticks=20))
fig.update_layout(
    xaxis=dict(
        tickformat='%Y-%m-%d',
        rangeselector=dict(
            buttons=list([
                dict(count=1, label="1d", step="day", stepmode="backward"),
                dict(count=7, label="1w", step="day", stepmode="backward"),
                dict(count=1, label="1m", step="month", stepmode="backward"),
                dict(count=1, label="1y", step="year", stepmode="backward"),
                dict(step="all")
            ])
        ),
        rangeslider=dict(visible=True),
        type="date",
        nticks=42,

    ),
    height=600
)

fig.add_trace(
    plt.Scatter(x=selected_data['date'], y=selected_data['amount'], name='Amount', line=dict(color='red'), yaxis='y2'))

# Update layout for the second y-axis
fig.update_layout(
    yaxis2=dict(title='Amount', side='right', overlaying='y', showgrid=False),
)

fig.add_trace(
    plt.Scatter(x=selected_data['date'], y=selected_data['am/vol'], name='am/vol', line=dict(color='black'),
                yaxis='y3'))

# Update layout for the second y-axis
fig.update_layout(
    yaxis3=dict(title='am/vol', side='right', overlaying='y', showgrid=False),
)

st.plotly_chart(fig, use_container_width=True, weight=1200, height=1600)
