import os


class Config:
    BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
    SECRET_KEY = os.environ.get('SECRET_KEY') or 'you-will-never-guess'
    SQLALCHEMY_TRACK_MODIFICATIONS = True
    # SQLALCHEMY_DATABASE_URI = os.environ.get('DATABASE_URL') or 'mysql://root:s836659812@192.168.50.104/stock'
    SQLALCHEMY_DATABASE_URI = os.environ.get(
        'DATABASE_URL') or 'mysql://root:s836659812@xiaozhiwudi.asuscomm.com/stock?charset=utf8mb4'
    # SQLALCHEMY_DATABASE_URI = os.environ.get(
    #     'DATABASE_URL') or 'mysql://root:s836659812S.@47.100.86.197/stock?charset=utf8mb4'
    # # sqlalchemy-codegen mysql+pymysql://root:s836659812S.@47.100.86.197/stock?charset=utf8mb4 [--tables <tablenames>] [--notables]  --models_layer --controller_layer --outdir dist


class DevelopmentConfig(Config):
    DEBUG = True
    SQLALCHEMY_TRACK_MODIFICATIONS = True
    SQLALCHEMY_DATABASE_URI = os.environ.get('DATABASE_URL') or 'mysql://root:s836659812@192.168.50.104/stock'


class TestingConfig(Config):
    TESTING = True
    SQLALCHEMY_DATABASE_URI = os.environ.get('DATABASE_URL') or 'mysql://root:s836659812@192.168.50.104/stock'


class ProductionConfig(Config):
    DEBUG = False
    TESTING = False
