from datetime import datetime
from dateutil.relativedelta import relativedelta
import pandas as pd
def pd_chunk(df_chunk):
    chunk_list = []
    for chunk in df_chunk:
        chunk_list.append(chunk)
    result_pd = pd.concat(chunk_list)
    return result_pd

def baostock2tushare(stock_code: str):
    ins, code = stock_code.split(".")
    return f"{code}.{ins.upper()}"


def tushare2baostock(stock_code: str):
    code, ins = stock_code.split(".")
    return f"{ins.lower()}.{code}"

def today_format():
    current_time = datetime.now()
    formatted_time = current_time.strftime("%Y-%m-%d")
    return formatted_time


def today_YYYYMMDD():
    current_time = datetime.now()
    formatted_time = current_time.strftime("%Y%m%d")
    return formatted_time


def denifi_YYYYMMDD(sub_year=0):
    current_time = datetime.now()
    # 减去一年
    last_year_time = current_time - relativedelta(years=sub_year)
    formatted_time = last_year_time.strftime("%Y%m%d")
    return formatted_time


def convert_date_format(date_str):
    return f"{date_str[:4]}-{date_str[4:6]}-{date_str[6:]}"

def denifi_YYYYMM(sub_year=0):
    current_time = datetime.now()
    # 减去一年
    last_year_time = current_time - relativedelta(years=sub_year)
    formatted_time = last_year_time.strftime("%Y%m")
    return formatted_time