import tushare as ts
from sqlalchemy import text

from stock_sql.sql_env import stock_session, stock_db
from tool.stock_query import baostock2tushare

pro = ts.pro_api('09f391cea7cefe5233e34b755ecf064e62a6c753c355513acd7ee4ac')

def stock_info():
    # df = pro.index_classify(src='SW2021')
    df = pro.income(ts_code='300750.SZ')
    df2 = pro.index_classify(src='SW2021')

    insert_sql = ("select * from stock.stock_info where status = 1 and type = 1")
    stmt_inserted = text(insert_sql)
    results_insterted = stock_session.execute(stmt_inserted)
    inseted_set = [baostock2tushare(row_r[0]) for row_r in results_insterted]

    tushare_code = df["ts_code"].tolist()
    no_in = []
    for code in inseted_set:
        if code not in tushare_code:
            no_in.append(code)
    print(no_in)
    print(len(no_in))

def stock_income2sql():
    df = pro.income(ts_code='601318.SH')
    res = df.to_sql('stock_income', stock_db, index=False, if_exists='append', chunksize=5000)
    print(res)

def stock_shibor():
    df = pro.shibor()
    res = df.to_sql('stock_rate', stock_db, index=False, if_exists='append', chunksize=5000)
    print(res)
    df = pro.shibor_lpr()
    res = df.to_sql('stock_rate', stock_db, index=False, if_exists='append', chunksize=5000)
    print(res)

def stock_fund():
    #df = pro.fund_nav(nav_date="20250207")
    df = pro.fund_nav(ts_code="513110.SH")
    print(df)
    df = pro.fund_nav(ts_code="513110.OF")
    print(df)

def stock_express():
    pro = ts.pro_api()

    df = pro.fina_indicator(ts_code='300750.SZ')
    res = df.to_sql('stock_indicator', stock_db, index=False, if_exists='append', chunksize=5000)
    print(res)

def stock_au99():
    df = pro.sge_basic(ts_code="Au99.99")
    print(df)

def stock_basick():
    df = pro.stock_basic()
    print(df)

def stock_concept_detail():
    df = pro.concept_detail(id="TS6")
    print(df)

def stcok_hk_daily():
    df = pro.hk_daily()
    print(df)





if __name__ == '__main__':
    stcok_hk_daily()
