/*
back up sql
*/
create table stock.back_stock_detail as (select * from stock.stock_detail);
create table stock.back_trade_time as (select * from stock.trade_time);
create table stock.back_stock_status as (select * from stock.stock_status);
create table stock.back_stock_divid as (select * from stock.stock_divid);
create table stock.back_stock_info as (select * from stock.stock_info);


/*
retrieve unsynchornized code status records
*/
SELECT *
FROM stock.trade_time AS t1
LEFT JOIN (
    SELECT calendar_date, COUNT(code) AS code_count
    FROM stock.stock_status
    GROUP BY calendar_date
) AS t2 ON t1.calendar_date = t2.calendar_date 
where t1.is_trading_day = 1 and  t2.code_count is null and t1.calendar_date < curdate()  order by t1.calendar_date;

/*
retrieve lack code basic info records
*/
SELECT * FROM (SELECT DISTINCT(code) FROM stock.stock_status) AS t1 LEFT JOIN stock.stock_info AS t2 on  t1.code = t2.code 
where t2.code_name is null;

/*
retrieve lack code divid info
*/
SELECT * FROM stock.stock_info AS t1  left join  stock.stock_divid  AS t2 on  t1.code = t2.code where t2.code is null;

/*
update all record last_update data
*/
update stock.stock_info set last_update = (select last_time from stock.temp_stock_last where stock.temp_stock_last.code = stock.stock_info.code) ;

/*
get what stock code need to rebuild because divid
*/
select * from stock.stock_info as t1 left join (select max(dividOperateDate) as dividOperateDate,code from stock.stock_divid group by code) as t2 on t1.code = t2.code where t2.dividOperateDate > t1.last_divid;

/*
synchornized detail & info last_update
*/
select * from stock.stock_info as t1 left join
(select max(calendar_date) as last_update,code from stock.stock_detail group by code) as t2
on t1.code = t2.code where  t2.last_update is not null and(t1.last_update is null or t1.last_update !=t2.last_update) ;

/*
get what day stock update start
*/
select code,DATE_FORMAT(min(t2.calendar_date),'%Y-%m-%d') from stock.stock_info as t1 left join stock.trade_time as t2 on 1=1 
where t1.status = 1 and is_trading_day = 1 and t2.calendar_date > t1.last_update group by code;


