import logging

from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker, declarative_base

from config import Config
from stock_sql.orm.key_word import KeyWord
from stock_sql.orm.stock_detail import StockDetail
from stock_sql.orm.stock_divid import StockDivid
from stock_sql.orm.stock_etf import StockETF
from stock_sql.orm.stock_industry import StockIndustry
from stock_sql.orm.stock_info import StockInfo
from stock_sql.orm.stock_status import StockStatus
from stock_sql.orm.stock_swindustry import StockSwindustry
from stock_sql.orm.stock_top import StockTop
from stock_sql.orm.trade_time import TradeTime

Base = declarative_base()

# set env
logging.info("init db connect")
stock_db = create_engine(Config.SQLALCHEMY_DATABASE_URI, echo=False)
f_Session = sessionmaker(bind=stock_db)
stock_session = f_Session()


def create_table():
    # Base.metadata.create_all(stock_db,checkfirst=True)
    # create table
    TradeTime.__table__.create(stock_db, checkfirst=True)
    StockStatus.__table__.create(stock_db, checkfirst=True)
    StockDetail.__table__.create(stock_db, checkfirst=True)
    StockInfo.__table__.create(stock_db, checkfirst=True)
    StockDivid.__table__.create(stock_db, checkfirst=True)
    StockIndustry.__table__.create(stock_db, checkfirst=True)
    StockTop.__table__.create(stock_db, checkfirst=True)
    StockSwindustry.__table__.create(stock_db, checkfirst=True)
    KeyWord.__table__.create(stock_db, checkfirst=True)
    StockETF.__table__.create(stock_db, checkfirst=True)


if __name__ == '__main__':
    # sqlacodegen mysql+pymysql://root:s836659812S.@47.100.86.197/stock?charset=utf8mb4 --tables stock_income --outfile=stock_income.py
    create_table()

