# coding: utf-8
from sqlalchemy import Column, Date, Float, Integer
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class StockRate(Base):
    __tablename__ = 'stock_rate'

    date = Column(Date)
    on = Column(Float(asdecimal=True))
    _1w = Column('1w', Float(asdecimal=True))
    _2w = Column('2w', Float(asdecimal=True))
    _1m = Column('1m', Float(asdecimal=True))
    _3m = Column('3m', Float(asdecimal=True))
    _6m = Column('6m', Float(asdecimal=True))
    _9m = Column('9m', Float(asdecimal=True))
    _1y = Column('1y', Float(asdecimal=True))
    _5y = Column('5y', Float(asdecimal=True))
    id = Column(Integer, primary_key=True)
