from sqlalchemy import Column, Integer, String, Float, Date
from sqlalchemy.orm import declarative_base

Base = declarative_base()


class StockInfo(Base):
    __tablename__ = 'stock_info'
    code = Column(String(50), primary_key=True, nullable=False)
    code_name = Column(String(50))
    ipoDate = Column(Date)
    outDate = Column(Date)
    type = Column(Integer, comment="证券类型，其中1：股票，2：指数，3：其它，4：可转债，5：ETF")
    status = Column(Integer, comment="上市状态，其中1：上市，0：退市")
    last_update = Column(Date)
    last_divid = Column(Date)
    l1_code = Column(String(50))
    l1_name = Column(String(50))
    l2_code = Column(String(50))
    l2_name = Column(String(50))
    l3_code = Column(String(50))
    l3_name = Column(String(50))
