# coding: utf-8
from sqlalchemy import Column, Date, Float, Integer, String
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class StockIndicator(Base):
    __tablename__ = 'stock_indicator'
    id = Column(Integer, primary_key=True)
    ts_code = Column(String(50, 'utf8mb4_unicode_ci'))
    ann_date = Column(Date)
    end_date = Column(Date)
    eps = Column(Float(asdecimal=True))
    dt_eps = Column(Float(asdecimal=True))
    total_revenue_ps = Column(Float(asdecimal=True))
    revenue_ps = Column(Float(asdecimal=True))
    capital_rese_ps = Column(Float(asdecimal=True))
    surplus_rese_ps = Column(Float(asdecimal=True))
    undist_profit_ps = Column(Float(asdecimal=True))
    extra_item = Column(Float(asdecimal=True))
    profit_dedt = Column(Float(asdecimal=True))
    gross_margin = Column(Float(asdecimal=True))
    current_ratio = Column(Float(asdecimal=True))
    quick_ratio = Column(Float(asdecimal=True))
    cash_ratio = Column(Float(asdecimal=True))
    ar_turn = Column(Float(asdecimal=True))
    ca_turn = Column(Float(asdecimal=True))
    fa_turn = Column(Float(asdecimal=True))
    assets_turn = Column(Float(asdecimal=True))
    op_income = Column(Float(asdecimal=True))
    ebit = Column(Float(asdecimal=True))
    ebitda = Column(Float(asdecimal=True))
    fcff = Column(Float(asdecimal=True))
    fcfe = Column(Float(asdecimal=True))
    current_exint = Column(Float(asdecimal=True))
    noncurrent_exint = Column(Float(asdecimal=True))
    interestdebt = Column(Float(asdecimal=True))
    netdebt = Column(Float(asdecimal=True))
    tangible_asset = Column(Float(asdecimal=True))
    working_capital = Column(Float(asdecimal=True))
    networking_capital = Column(Float(asdecimal=True))
    invest_capital = Column(Float(asdecimal=True))
    retained_earnings = Column(Float(asdecimal=True))
    diluted2_eps = Column(Float(asdecimal=True))
    bps = Column(Float(asdecimal=True))
    ocfps = Column(Float(asdecimal=True))
    retainedps = Column(Float(asdecimal=True))
    cfps = Column(Float(asdecimal=True))
    ebit_ps = Column(Float(asdecimal=True))
    fcff_ps = Column(Float(asdecimal=True))
    fcfe_ps = Column(Float(asdecimal=True))
    netprofit_margin = Column(Float(asdecimal=True))
    grossprofit_margin = Column(Float(asdecimal=True))
    cogs_of_sales = Column(Float(asdecimal=True))
    expense_of_sales = Column(Float(asdecimal=True))
    profit_to_gr = Column(Float(asdecimal=True))
    saleexp_to_gr = Column(Float(asdecimal=True))
    adminexp_of_gr = Column(Float(asdecimal=True))
    finaexp_of_gr = Column(Float(asdecimal=True))
    impai_ttm = Column(Float(asdecimal=True))
    gc_of_gr = Column(Float(asdecimal=True))
    op_of_gr = Column(Float(asdecimal=True))
    ebit_of_gr = Column(Float(asdecimal=True))
    roe = Column(Float(asdecimal=True))
    roe_waa = Column(Float(asdecimal=True))
    roe_dt = Column(Float(asdecimal=True))
    roa = Column(Float(asdecimal=True))
    npta = Column(Float(asdecimal=True))
    roic = Column(Float(asdecimal=True))
    roe_yearly = Column(Float(asdecimal=True))
    roa2_yearly = Column(Float(asdecimal=True))
    debt_to_assets = Column(Float(asdecimal=True))
    assets_to_eqt = Column(Float(asdecimal=True))
    dp_assets_to_eqt = Column(Float(asdecimal=True))
    ca_to_assets = Column(Float(asdecimal=True))
    nca_to_assets = Column(Float(asdecimal=True))
    tbassets_to_totalassets = Column(Float(asdecimal=True))
    int_to_talcap = Column(Float(asdecimal=True))
    eqt_to_talcapital = Column(Float(asdecimal=True))
    currentdebt_to_debt = Column(Float(asdecimal=True))
    longdeb_to_debt = Column(Float(asdecimal=True))
    ocf_to_shortdebt = Column(Float(asdecimal=True))
    debt_to_eqt = Column(Float(asdecimal=True))
    eqt_to_debt = Column(Float(asdecimal=True))
    eqt_to_interestdebt = Column(Float(asdecimal=True))
    tangibleasset_to_debt = Column(Float(asdecimal=True))
    tangasset_to_intdebt = Column(Float(asdecimal=True))
    tangibleasset_to_netdebt = Column(Float(asdecimal=True))
    ocf_to_debt = Column(Float(asdecimal=True))
    turn_days = Column(Float(asdecimal=True))
    roa_yearly = Column(Float(asdecimal=True))
    roa_dp = Column(Float(asdecimal=True))
    fixed_assets = Column(Float(asdecimal=True))
    profit_to_op = Column(Float(asdecimal=True))
    q_saleexp_to_gr = Column(Float(asdecimal=True))
    q_gc_to_gr = Column(Float(asdecimal=True))
    q_roe = Column(Float(asdecimal=True))
    q_dt_roe = Column(Float(asdecimal=True))
    q_npta = Column(Float(asdecimal=True))
    q_ocf_to_sales = Column(Float(asdecimal=True))
    basic_eps_yoy = Column(Float(asdecimal=True))
    dt_eps_yoy = Column(Float(asdecimal=True))
    cfps_yoy = Column(Float(asdecimal=True))
    op_yoy = Column(Float(asdecimal=True))
    ebt_yoy = Column(Float(asdecimal=True))
    netprofit_yoy = Column(Float(asdecimal=True))
    dt_netprofit_yoy = Column(Float(asdecimal=True))
    ocf_yoy = Column(Float(asdecimal=True))
    roe_yoy = Column(Float(asdecimal=True))
    bps_yoy = Column(Float(asdecimal=True))
    assets_yoy = Column(Float(asdecimal=True))
    eqt_yoy = Column(Float(asdecimal=True))
    tr_yoy = Column(Float(asdecimal=True))
    or_yoy = Column(Float(asdecimal=True))
    q_sales_yoy = Column(Float(asdecimal=True))
    q_op_qoq = Column(Float(asdecimal=True))
    equity_yoy = Column(Float(asdecimal=True))

