# coding: utf-8
from sqlalchemy import BigInteger, Column, Date, Float, Text
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()



class StockGold(Base):
    __tablename__ = 'stock_gold'

    instrument_id = Column(Text(collation='utf8mb4_unicode_ci'))
    time_type = Column(Text(collation='utf8mb4_unicode_ci'))
    datetime = Column(Date, primary_key=True)
    open_price = Column(Float(asdecimal=True))
    close_price = Column(Float(asdecimal=True))
    highest_price = Column(Float(asdecimal=True))
    lowest_price = Column(Float(asdecimal=True))
    settlement_price = Column(Float(asdecimal=True))
    volume = Column(BigInteger)
    open_interest = Column(BigInteger)
    init_volume = Column(BigInteger)
    zhu_lian_id = Column(Text(collation='utf8mb4_unicode_ci'))
