from sqlalchemy import Column, Integer, String, Float, Date
from sqlalchemy.orm import declarative_base

Base = declarative_base()


class StockETF(Base):
    __tablename__ = 'stock_etf'

    etf_code = Column(String(50), primary_key=True)
    etf_name = Column(String(50))
    etf_date = Column(Date, primary_key=True)
    close = Column(Float(asdecimal=True))
    t_1_value = Column(Float(asdecimal=True))
    t_1_nav = Column(Float(asdecimal=True))
    nav_error = Column(Float(asdecimal=True))
    t_1_premium = Column(Float(asdecimal=True))
    count_number = Column(Integer)
    count_incre = Column(Float(asdecimal=True))
    t_1_index_incre = Column(Float(asdecimal=True))
