# key_word
from sqlalchemy import Column, BigInteger, String, Float, Date, Integer, Text, DateTime
from sqlalchemy.orm import declarative_base

Base = declarative_base()


class KeyWord(Base):
    __tablename__ = 'key_word'
    uuid = Column(Integer, primary_key=True, autoincrement=True)  # 自增 ID
    src = Column(String(50))
    type = Column(String(50))
    title = Column(Text)
    content = Column(Text)
    url = Column(Text)
    cache_time = Column(DateTime)
    update_time = Column(DateTime)

    def __repr__(self):
        return f"null"
