import streamlit as st

from stock_sql.query_platform import query_trade_cal, pro, get_ah

select_day = st.sidebar.selectbox(
    "选择交易日",
    query_trade_cal()["cal_date"].tolist(),
    index=0,
    placeholder="选择交易日",
)

st.markdown("## 沪深股通十大")
st.dataframe(pro.hsgt_top10(trade_date=select_day))

st.markdown("## 港股通十大")
st.dataframe(pro.ggt_top10(trade_date=select_day))

st.markdown("## AH溢价股票")
st.dataframe(get_ah())
