import pandas as pd
import plotly.graph_objects as go
import streamlit as st
from pandas import DataFrame
from stock_sql.query_platform import pro_bar, query_global_index, pro
from stock_sql.query_sql import query_gold, query_keyword, query_etf, \
    query_ditinct_code
from tool.stock_utils import denifi_YYYYMMDD


@st.cache_data
def gold_data():
    return query_gold()


@st.cache_data
def sh_code():
    return pro_bar("000001.SH", "I")


@st.cache_data
def global_index_data(index: str):
    return query_global_index(index)


def keyword_data(type="", number=100):
    return query_keyword(type=type, number=number)


def etf_data(etf_name=""):
    return query_etf(etf_name)


def distinct_code(distinct_code=""):
    ret_pd = query_ditinct_code(distinct_code)
    if ret_pd is not None:
        return ret_pd[distinct_code].tolist()
    return None


st.set_page_config(
    page_title="Mind！",
    page_icon="👋",
)
st.markdown("## 金价")
# df_gold = gold_data()
df_gold = pro.sge_daily(ts_code="Au99.99", start_date=denifi_YYYYMMDD(3))
df_gold['trade_date'] = pd.to_datetime(df_gold['trade_date'], format='%Y%m%d')
hovertext = []
for i in range(len(df_gold['trade_date'])):
    hovertext.append('Date: ' + str(df_gold['trade_date'][i])
                     + '<br>Open: ' + str(df_gold['open'][i])
                     + '<br>Close: ' + str(df_gold['close'][i])
                     + '<br>Diff: ' + str(round(df_gold['close'][i] - df_gold['open'][i], 2))
                     )

fig = go.Figure(data=go.Ohlc(
    x=df_gold['trade_date'],
    open=df_gold['open'],  # 字段数据必须是元组、列表、numpy数组、或者pandas的Series数据
    high=df_gold['high'],
    low=df_gold['low'],
    close=df_gold['close'],
    increasing_line_color='red',
    decreasing_line_color='green',
    text=hovertext,
    hoverinfo='text'
))

fig.update(layout_xaxis_rangeslider_visible=False)
st.plotly_chart(fig)

st.markdown("## 上证")
df_szcode = sh_code()
df_szcode['trade_date'] = pd.to_datetime(df_szcode['trade_date'], format='%Y%m%d')
hovertext_sz = []
for i in range(len(df_szcode['trade_date'])):
    hovertext_sz.append('Date: ' + str(df_szcode['trade_date'][i])
                        + '<br>Open: ' + str(df_szcode['open'][i])
                        + '<br>Close: ' + str(df_szcode['close'][i])
                        + '<br>Diff: ' + str(round(df_szcode['close'][i] - df_szcode['open'][i], 2))
                        )
fig_sz = go.Figure(data=go.Ohlc(
    x=df_szcode['trade_date'],
    open=df_szcode['open'],  # 字段数据必须是元组、列表、numpy数组、或者pandas的Series数据
    high=df_szcode['high'],
    low=df_szcode['low'],
    close=df_szcode['close'],
    increasing_line_color='red',
    decreasing_line_color='green',
    text=hovertext_sz,
    hoverinfo='text'
))
fig_sz.update(layout_xaxis_rangeslider_visible=False)
st.plotly_chart(fig_sz)

st.markdown("## 热点中心")
option_src = st.selectbox(
    "choose info src",
    distinct_code("src"),
    index=0,
    placeholder="Select info src...",
)
option_number = st.selectbox(
    "choose info number",
    [100, 300, 500],
    index=0,
    placeholder="Select info number...",
)

pd_keyword = keyword_data(type=option_src, number=option_number)
pd_keyword = pd_keyword.drop('uuid', axis=1)
pd_keyword = pd_keyword.drop('cache_time', axis=1)
st.dataframe(pd_keyword)

st.markdown("## ETF溢价率")
option_etf_name = st.selectbox(
    "choose etf_name",
    distinct_code("etf_name"),
    index=None,
    placeholder="Select info etf_name",
)
pd_etf = etf_data(option_etf_name)
st.line_chart(pd_etf, x="etf_date", y="t_1_premium", color="etf_name")

st.markdown("## 国际指数")
option_global_index = st.selectbox(
    "choose info number",
    ["SPX_标普500", "HSI_恒生", "HKAH_恒生AH", "DJI_道琼斯工业", "IXIC_纳斯达克"],
    index=0,
    placeholder="Select info number..."
)
df_global_index = global_index_data(option_global_index.split("_")[0])

df_global_index['trade_date'] = pd.to_datetime(df_global_index['trade_date'], format='%Y%m%d')
fig_global = go.Figure(data=go.Ohlc(
    x=df_global_index['trade_date'],
    open=df_global_index['open'],  # 字段数据必须是元组、列表、numpy数组、或者pandas的Series数据
    high=df_global_index['high'],
    low=df_global_index['low'],
    close=df_global_index['close'],
    increasing_line_color='red',
    decreasing_line_color='green'
))

fig_global.update(layout_xaxis_rangeslider_visible=False)
st.plotly_chart(fig_global)

st.markdown("### 国债5年收益率")
pd_yc_cb: DataFrame = pro.yc_cb(ts_code="1001.CB", curve_term=5)
st.line_chart(pd_yc_cb, x="trade_date", y="yield")
